<?php

function unistr_to_ords($str, $encoding = 'UTF-8'){        
    // Turns a string of unicode characters into an array of ordinal values,
    // Even if some of those characters are multibyte.
    $str = mb_convert_encoding($str,"UCS-4BE",$encoding);
    $ords = "";;
    
    // Visit each unicode character
    for($i = 0; $i < mb_strlen($str,"UCS-4BE"); $i++){        
        // Now we have 4 bytes. Find their total
        // numeric value.
        $s2 = mb_substr($str,$i,1,"UCS-4BE");                    
        $val = unpack("N",$s2);            
        $ords.= $val[1];                
    }        
    return($ords);
}

function getEncodingOrder()
   {
   $ary[] = 'UTF-32';
   $ary[] = 'UTF-32BE';
   $ary[] = 'UTF-32LE';
   $ary[] = 'UTF-16';
   $ary[] = 'UTF-16BE';
   $ary[] = 'UTF-16LE';
   $ary[] = 'UTF-8';
   $ary[] = 'ASCII';
   $ary[] = 'ISO-2022-JP';
   $ary[] = 'JIS';
   $ary[] = 'windows-1252';
   $ary[] = 'windows-1251';
   $ary[] = 'UCS-2LE';
   $ary[] = 'SJIS-win';
   $ary[] = 'EUC-JP';
    
   return $ary;
   }

function tms_convert_value($value, $key)
    {
    global $tms_link_numeric_columns, $tms_link_text_columns;

    $encoding = mb_detect_encoding($value, getEncodingOrder(), true);

    // Check if field is defined as UTF-16 or it's not an UTF-8 field
    if(in_array($key, $tms_link_text_columns) || !in_array($key, $tms_link_numeric_columns))
        {
        return mb_convert_encoding($value, 'UTF-8', 'UCS-2LE');
        }

    return $value;
    }


function tms_link_get_tms_data($resource,$tms_object_id="",$resourcechecksum="")
  {
  global $tms_link_dsn_name,$tms_link_user,$tms_link_password, $tms_link_checksum_field, $tms_link_table_name,$tms_link_object_id_field, $tms_link_text_columns, $tms_link_numeric_columns;
  
  $tms_link_columns;
  
  $conn=odbc_connect($tms_link_dsn_name, $tms_link_user, $tms_link_password);
  
  if($conn)
    {
    // Get checksum if if we haven't been passed it
    if($resourcechecksum==""){$resourcechecksum=get_data_by_field($resource, $tms_link_checksum_field);}
    //echo "Checksum=" . $resourcechecksum;
    
    // Get TMS if if we haven't been passed it
    if($tms_object_id==""){$tms_object_id=get_data_by_field($resource, $tms_link_object_id_field);}  
    
    if($tms_object_id==""){return false;} // We don't have any ID to get data for
    
    if(is_array($tms_object_id))
      {
      $conditionsql = " where ObjectID in ('" . implode("','", $tms_object_id) . "')";
      }    
    else
      {
      $conditionsql = " where ObjectID ='" . $tms_object_id . "'";
      }
    
    
    //echo "TMS Object ID =" . $tms_object_id;
        
    //$tmssql="SELECT * FROM " . $tms_link_table_name . " where ObjectID ='" . $tms_object_id . "';";
    
    // Add normal value fields
    $columnsql = implode(", ", $tms_link_numeric_columns);
    
    // Add SQL to get back text fields as VARBINARY(MAX) so we can sort out encoding later
    foreach ($tms_link_text_columns as $tms_link_text_column)
      {
      $columnsql.=", CAST (" . $tms_link_text_column . " AS VARBINARY(MAX)) " . $tms_link_text_column;
      }
    
    
    $tmssql = "SELECT " . $columnsql . " FROM " . $tms_link_table_name . $conditionsql . " ;";
    
    //exit($tmssql);
    
    // Execute the query to get the data from TMS
    $tmsresultset = odbc_exec($conn,$tmssql);
    
    $resultcount=odbc_num_rows ($tmsresultset);
    if($resultcount==0){global $lang;return $lang["tms_link_no_tms_data"];}
    
    $convertedtmsdata=array();
    for ($r=1;$r<=$resultcount;$r++)
      {    
      $tmsdata=odbc_fetch_array ($tmsresultset,$r);
      
      if(is_array($tms_object_id))
        {
        foreach($tmsdata as $key=>$value)
          {
          $convertedtmsdata[$r][$key]=tms_convert_value($value, $key);
          }
        }
      else
        {
        foreach($tmsdata as $key=>$value)
          {
          $convertedtmsdata[$key]=tms_convert_value($value, $key);
          }
        }
        
      }
      //exit(print_r($convertedtmsdata));
      return $convertedtmsdata;
    }
  else
    {
    
    $error=odbc_errormsg();
    exit($error);
    return $error;
    }
    
  }

function tms_link_get_tms_resources()
  {
  global $tms_link_checksum_field,$tms_link_object_id_field, $tms_test_count, $tms_link_resource_types;
  
  
  $tms_resources=sql_query("select rd.resource as resource, rd.value as objectid, rd2.value as checksum from resource_data rd left join resource_data rd2 on rd2.resource=rd.resource and rd2.resource_type_field='" . $tms_link_checksum_field . "' WHERE rd.resource>0 and rd.resource_type_field='" . $tms_link_object_id_field . "' order by rd.resource");
    
  return $tms_resources;  
  
  }
  
  
  
  
function tms_link_test()
  {
  global $tms_link_dsn_name,$tms_link_user,$tms_link_password, $tms_link_checksum_field, $tms_link_table_name,$tms_link_object_id_field, $tms_link_text_columns, $tms_link_numeric_columns;
  
  $tms_link_columns;
  
  $conn=odbc_connect($tms_link_dsn_name, $tms_link_user, $tms_link_password);
  
  if($conn)
    {  
    
        
    // Add normal value fields
    $columnsql = implode(", ", $tms_link_numeric_columns);
    
    // Add SQL to get back text fields as VARBINARY(MAX) so we can sort out encoding later
    foreach ($tms_link_text_columns as $tms_link_text_column)
      {
      $columnsql.=", CAST (" . $tms_link_text_column . " AS VARBINARY(MAX)) " . $tms_link_text_column;
      }
    
    
    $tmssql = "SELECT TOP 10 * FROM " . $tms_link_table_name . " ;";
    
    // Execute the query to get the data from TMS
    $tmsresultset = odbc_exec($conn,$tmssql);
    
    $resultcount=odbc_num_rows ($tmsresultset);
    if($resultcount==0){global $lang;return $lang["tms_link_no_tms_data"];}
    
    $convertedtmsdata=array();
    for ($r=1;$r<=$resultcount;$r++)
      {    
      $tmsdata=odbc_fetch_array ($tmsresultset,$r);
      
    
      foreach($tmsdata as $key=>$value)
        {        
        $convertedtmsdata[$key]=$value;
        }
        
        
      }
      //exit(print_r($convertedtmsdata));
      return $convertedtmsdata;
    }
  else
    {
    
    $error=odbc_errormsg();
    exit($error);
    return $error;
    }
    
  }  
  
  
function tms_link_create_tms_thumbnail($resource, $alternative=-1)
  {
  global $conn,$tms_link_dsn_name,$tms_link_user,$tms_link_password, $tms_link_checksum_field, $tms_link_table_name,$tms_link_object_id_field, $tms_link_text_columns, $tms_link_numeric_columns, $tms_link_tms_loginid,$storagedir, $tms_link_media_path, $tms_link_push_image_sizes;
  
  //  Set up connection, need to increase bytes returned
  ini_set("odbc.defaultlrl", "100K");
  $conn=odbc_connect($tms_link_dsn_name, $tms_link_user, $tms_link_password);

  if($conn)
    {
    // Check if we already have a TMS ID
    $tms_object_id=get_data_by_field($resource, $tms_link_object_id_field);
    if($tms_object_id==""){return false;} // No TMS ID found, we can't add the image to TMS
        
        // ============================ STEP 1: MediaMaster Table ================================
        // Get a MediaMaster record ID to use, if there is not one unused then create one
        $mediamasterid = tms_get_mediamasterid();
        if(!$mediamasterid)
          {
          debug("tms_link: ERROR: Unable to get a MediaMasterID. " . $errormessage);
            echo "tms_link: ERROR: Unable to get a MediaMasterID. " . $errormessage . "<br>";
          return false;
          }      
        debug("tms_link: Using MediaMasterID: " . $mediamasterid);
        echo "tms_link: Using MediaMasterID: " . $mediamasterid . "<br>";

        // ============================ STEP 2: MediaRenditions Table ============================
        $renditionid=tms_get_renditionid($mediamasterid,$resource,true);
        if(!$renditionid)
          {
          debug("ERROR: Unable to create a new RenditionID. " . $errormessage);
          echo "ERROR: Unable to create a new RenditionID. " . $errormessage . "<br>";
          return false;
          }     
    debug("Using RenditionID: " . $renditionid);
    echo "Using RenditionID: " . $renditionid . "<br>";
        
        // UPDATE MediaMaster with new value
        $tmssql="UPDATE MediaMaster Set DisplayRendID = '" . $renditionid . "', PrimaryRendID = '" . $renditionid . "' WHERE MediaMasterID = '" . $mediamasterid . "'";
        odbc_exec($conn,$tmssql);
        $tms_set_rendition=odbc_exec($conn,$tmssql);
        if(!$tms_set_rendition)
          {
          $errormessage=odbc_errormsg();
          debug("tms_link: SQL = " . $tmssql);
          debug("tms_link: Unable to update MediaMaster table with RenditionID " . $errormessage);
          return false;
          }
    
        $pathid=tms_get_mediapathid($tms_link_media_path);
        debug("tms_link: Found PathID for " . $tms_link_media_path . " - " . $pathid);
        // ============================ STEP 3: MediaFiles Table ====================================
        foreach($tms_link_push_image_sizes as $tms_link_push_image_size)
          {
          $preview_path=get_resource_path($resource,true,$tms_link_push_image_size,false);
          if(file_exists($preview_path) && filesize_unlimited($preview_path)<65536)
              {
              if(isset($storagedir) && $storagedir!="")
                  {
                  $tmsrelfilepath=substr($preview_path,strlen($storagedir) + 1);
                  }
              else
                  {
                  $tmsrelfilepath=substr($preview_path,strpos($preview_path,'filestore')+10);
                  }
              break;
              }
          }
        if(!isset($tmsrelfilepath))
          {
          echo "No valid image files found to be uploaded<br>";
          debug("No valid image files found to be uploaded");
          return fasle;
          }
      
        echo "Found preview file to use: " . $preview_path . "<br>Relative path: " . $tmsrelfilepath . "<br>";
        $mediafileid=tms_add_mediafile($renditionid,$pathid,$preview_path,$tmsrelfilepath,true);
        debug("tms_link: added new mediafile in MediaXRefs. Media FileID: " . $mediafileid);
              echo "tms_link: added new mediafile in MediaXRefs. Media FileID: " . $mediafileid . "<br>";
        
        // Update MediaRenditions with new mediafile
        $updaterendition=tms_update_media_rendition($mediamasterid,$mediafileid);
        if(!$updaterendition)
          {
          debug("tms_link: ERROR: Unable to update media rendition");
          echo "tms_link: ERROR: Unable to update media rendition<br>";
            return false;
          }
          
        // Update MediaRenditions with new thumbnail
        tms_update_media_rendition_thumb($mediamasterid,$mediafileid, $pathid, $preview_path,$tmsrelfilepath);        
    }
    
  else
    {
    $error=odbc_errormsg();
    exit($error);
    return false;
    }
    
  }

  
function tms_link_save_data($resource,$tms_object_id=false, $field="all")
  {  
  global $tms_link_dsn_name,$tms_link_user,$tms_link_password, $tms_link_checksum_field, $tms_link_table_name,$tms_link_object_id_field, $tms_link_text_columns, $tms_link_numeric_columns;
  
  $conn=odbc_connect($tms_link_dsn_name, $tms_link_user, $tms_link_password);
  
  if($conn)
    {
    // Get TMS object ID if if we haven't been passed it
    if($tms_object_id==""){$tms_object_id=get_data_by_field($resource, $tms_link_object_id_field);}  
    
    if($tms_object_id==""){return false;} // We don't have any ID to save data for
    if($field="all") 
      {
      // Save all data
      }
    else
      {
      // Save data for specific field e.g. on autosave
      }
    //$tmssql="SELECT * FROM " . $tms_link_table_name . " where ObjectID ='" . $tms_object_id . "';"
    // Add normal value fields
    $columnsql = implode(", ", $tms_link_numeric_columns);
    
    // Add SQL to get back text fields as VARBINARY(MAX) so we can sort out encoding later
    foreach ($tms_link_text_columns as $tms_link_text_column)
      {
      $columnsql.=", CAST (" . $tms_link_text_column . " AS VARBINARY(MAX)) " . $tms_link_text_column;
      }
    
    
    $tmssql = "SELECT " . $columnsql . " FROM " . $tms_link_table_name . $conditionsql . " ;";
    
    //exit($tmssql);
    
    // Execute the query to get the data from TMS
    $tmsresultset = odbc_exec($conn,$tmssql);
    
    $resultcount=odbc_num_rows ($tmsresultset);
    if($resultcount==0){global $lang;return $lang["tms_link_no_tms_data"];}
    
    $convertedtmsdata=array();
    for ($r=1;$r<=$resultcount;$r++)
      {    
      $tmsdata=odbc_fetch_array ($tmsresultset,$r);
      
      if(is_array($tms_object_id))
        {
        foreach($tmsdata as $key=>$value)
          {
          $convertedtmsdata[$r][$key]=tms_convert_value($value, $key);
          }
        }
      else
        {
        foreach($tmsdata as $key=>$value)
          {
          $convertedtmsdata[$key]=tms_convert_value($value, $key);
          }
        }
        
      }
      //exit(print_r($convertedtmsdata));
      return $convertedtmsdata;
    }
  else
    {
    
    $error=odbc_errormsg();
    exit($error);
    return $error;
    }
  
  }
  
function tms_get_mediamasterid($create=true)
  {
  global $conn, $errormessage, $test_tms_user;
  // Get the latest inserted ID that we have not used
  $tmssql = "select MediaMasterID FROM MediaMaster where LoginID = '" . $test_tms_user . "' and DisplayRendID='-1' and PrimaryRendID='-1'";
  $mediamasterresult=odbc_exec($conn,$tmssql);

  if(!$mediamasterresult)
    {
    debug("tms_link: SQL = " . $tmssql); 
    $errormessage=odbc_errormsg();
    debug("tms_link: ERROR = " . $errormessage);  
    return false;
    }
  $mediamasterids=array();

  while($row = odbc_fetch_array($mediamasterresult ))
    {
    $mediamasterids[] = $row["MediaMasterID"];
    }
  if(count($mediamasterids)>0)
    {
    debug("tms_link: FOUND " . count($mediamasterids) . " available MediaMasterIDs =" . implode(",",$mediamasterids));
    return $mediamasterids[0];
    }
  elseif($create)  
    {
    $tmssql="INSERT INTO MediaMaster (LoginID,DisplayRendID, PrimaryRendID) VALUES ('" . $test_tms_user . "',-1,-1)";
    $tmsinsert=odbc_exec($conn,$tmssql);
    if(!$tmsinsert)
      {
      $errormessage=odbc_errormsg();
      debug("tms_link: ERROR = " . $errormessage);  
      return false;
      }
    $newmasterid=tms_get_mediamasterid(false);
    return $newmasterid;
    }
  else  
    {
    return false;
    }
  }  
  
    
function tms_get_renditionid($mediamasterid,$resourceid,$create=true)
  {
  global $conn, $test_tms_user;
  // Get the latest ID that we have not used
  $tmssql = "select RenditionID, RenditionNumber,SortNumber,MediaTypeID,ParentRendID,LoginID FROM MediaRenditions where MediaMasterID='" . $mediamasterid . "' and LoginID='" . $test_tms_user . "'";
  $renditionresult=odbc_exec($conn,$tmssql);

  if(!$renditionresult)
    {
    debug("tms_link: SQL = " . $tmssql); 
    $errormessage=odbc_errormsg();    
    debug("tms_link: ERROR = " . $errormessage);  
    return false;
    }
  $renditionids=array();

  while($row = odbc_fetch_array($renditionresult))
    {
    $renditionids[] = $row["RenditionID"];
    }
  if(count($renditionids)>0)
    {
    debug("tms_link: FOUND " . count($renditionids) . " available RenditionIDs<br><ul><li>" . implode("</li><li>",$renditionids));
    return $renditionids[0];
    }
  elseif($create)  
    {
    $tmssql="INSERT INTO MediaRenditions (MediaMasterID, RenditionNumber,SortNumber,MediaTypeID,ParentRendID,LoginID) VALUES ('" . $mediamasterid . "', '" . $resourceid . "','" . $resourceid . "', 1, -1, '" . $test_tms_user . "')";
    $tmsinsert=odbc_exec($conn,$tmssql);
    if(!$tmsinsert)
      {
      debug("tms_link: SQL = " . $tmssql);  
      $errormessage=odbc_errormsg();
      debug("tms_link: ERROR = " . $errormessage);  
      return false;
      }
    $renditionid=tms_get_renditionid($mediamasterid,$resourceid,false);
    return $renditionid;
    }
  else  
    {
    return false;
    }
  }
  
  
function tms_get_mediapathid($path,$create=true)
  {
  global $conn,$test_tms_user;
  $tmssql = "select PathID FROM MediaPaths where PhysicalPath = '" . $path . "'";
  $mediapathresult=odbc_exec($conn,$tmssql);
  if(!$mediapathresult)
    {
    debug("tms_link: SQL = " . $tmssql); 
    $errormessage=odbc_errormsg();    
    debug("tms_link: ERROR = " . $errormessage); 
    return false;
    }
   $resultcount=odbc_num_rows ($mediapathresult);
  if($resultcount>0)
    {
    $mediapathids = odbc_fetch_array($mediapathresult);
    echo "tms_link: found PathID for " . $path . " - " . $mediapathids["PathID"] . "<br>";
    return $mediapathids["PathID"];
    }
  else
    {
    if(!$create)
      {
      return false;  
      }
    echo "tms_link: creating media path for " . $path . "<br>";
      $tmssql="INSERT INTO MediaPaths (Path,LoginID, PhysicalPath) VALUES ('" . $path . "','" . $test_tms_user . "','" . $path . "')";
    $tmsinsert=odbc_exec($conn,$tmssql);
    if(!$tmsinsert)
      {
      debug("tms_link: SQL = " . $tmssql); 
      $errormessage=odbc_errormsg();    
      debug("tms_link: ERROR = " . $errormessage); 
      return false;
      }
    $newpathid=tms_get_mediapathid($path,false);
    return $newpathid;
    }
  
  }

  
function tms_update_media_rendition($mediamasterid,$mediafileid)
  {
  global $conn;
  $tmssql="UPDATE MediaRenditions Set PrimaryFileID = '" . $mediafileid . "' where MediaMasterID = '" . $mediamasterid . "'";
  echo $tmssql . "<br>";
  $tms_update_mediafile=odbc_exec($conn,$tmssql);
  if(!$tms_update_mediafile)
    {
    debug("tms_link: SQL = " . $tmssql); 
    $errormessage=odbc_errormsg();    
    debug("tms_link: ERROR = " . $errormessage); 
     echo "tms_link: ERROR = " . $errormessage . "<br>";
    return false;
    }
  return true;
  }

function tms_update_media_rendition_thumb($mediamasterid,$mediafileid, $pathid, $filepath,$filename)
  {
  global $conn, $tmslocalpath;
  if(!file_exists($filepath)){return false;}
  
  $imagesize=filesize ($filepath);
  $imagebinarydata=file_get_contents($filepath);  
  
    $unpacked = unpack('H*hex', $imagebinarydata);
    $safeimagebinarydata =  '0x' . $unpacked['hex'];
  
  debug("tms_link: Adding thumbnail from " . $filepath);
    
  $tmssql="UPDATE MediaRenditions Set ThumbPathID = '" . $pathid . "', ThumbFileName='" . $filename . "',ThumbBlob=" . $safeimagebinarydata . ",ThumbBlobSize='" . $imagesize . "'";
      
  $tmssql .= " where MediaMasterID = '" . $mediamasterid . "' and PrimaryFileID = '" . $mediafileid . "'";
  
  $tms_update_thumb=odbc_exec($conn,$tmssql);
  if(!$tms_update_thumb)
    {
    $errormessage=odbc_errormsg();
    exit($errormessage);
    }
  return true;
  }
// $mediafileid=tms_add_mediafile($renditionid,$pathid,$tmsrelfilepath,true);
function tms_add_mediafile($renditionid,$pathid,$filepath,$relfilepath,$create=true)
  {
  global $conn,$tms_link_user;
  
  // Check if the file already exists
  $tmssql = "select FileID FROM MediaFiles where RenditionID='" . $renditionid . "' and PathID='" . $pathid . "' and Filename='" . $relfilepath. "' and LoginID='" . $tms_link_user. "'";
  $mediafileresult=odbc_exec($conn,$tmssql);

  if(!$mediafileresult)
    {
    $errormessage=odbc_errormsg();
    return false;
    }
  $mediafileids=array();

  while($row = odbc_fetch_array($mediafileresult))
    {
    $mediafileids[] = $row["FileID"];
    }
  if(count($mediafileids)>0)
    {
    debug("Found existing mediafile");
    echo "Found existing mediafile: " .  $mediafileids[0] . "<br>"; 
    return $mediafileids[0];
    }
  elseif($create)
    {
    $imageinfo=getimagesize($filepath);
    $imagesize=filesize ($filepath);

    $imagepxwidth=$imageinfo[0];
    $imagepxheight=$imageinfo[1];

    // The following was worked out from existing TMS data. Memory size =(PixelH * PixelW * 3) + (PixelH * n) WHERE n is 1,2, or 3
    $imagememorysize=($imagepxwidth * $imagepxheight * 3) + ($imagepxheight * 3);

    $tmssql="INSERT INTO MediaFiles
      (RenditionID, PathID, Filename, FormatID, PixelH, PixelW, ColorDepthID, FileSize, MemorySize,  FileDate, LoginID, LockChecksum, IsConfidential) 
      values ('" . $renditionid . "','" . $pathid . "', '" . $relfilepath. "', 2, '" . $imagepxheight . "', '" . $imagepxwidth . "', 0, '" . $imagesize . "','" . $imagememorysize . "', GETDATE(), '" . $tms_link_user. "', 0, 0)";
    $tms_insert_mediafile=odbc_exec($conn,$tmssql);
    if(!$tms_insert_mediafile)
      {
      $errormessage=odbc_errormsg();
      exit($errormessage);
      }  
    $mediafileid=tms_add_mediafile($renditionid,$pathid,$filepath,$relfilepath,false);
    return $mediafileid;    
    }
  else
    {
    debug("Unable to create new mediafile");
    echo "Unable to create new mediafile <br />";
    return false;
    }
  
  }
  
function tms_show_data($table,$columns,$utf16_columns,$conditionsql,$limit=10)
  {
  global $conn;
  $all_columns=array_merge($columns,$utf16_columns);

  // Add normal value fields
  $columnsql="";
  if($limit!=0)
    {
    $columnsql.="TOP 10 ";  
    }
  $columnsql .= implode(", ", $columns);

  
  // Add SQL to get back text fields as VARBINARY(MAX) so we can sort out encoding later
  foreach ($utf16_columns as $utf16_column)
    {
    $columnsql.=", CAST (" . $utf16_column . " AS VARBINARY(MAX)) " . $utf16_column;
    }
  
  $tmssql = "SELECT " . $columnsql . " FROM TMS.dbo.". $table . " " . $conditionsql;
  
  
  // Execute the query to get the data from TMS
  $tmsresultset = odbc_exec($conn,$tmssql);
  if(!$tmsresultset)
    {
    $error=odbc_errormsg();
    exit($error);
    }
  
  //exit(print_r($tmsresultset));
  $resultcount=odbc_num_rows ($tmsresultset);

  echo "<h2>TMS OUTPUT</h2>";
  echo "<p>QUERY: " . $tmssql . "</p>";
  echo "FOUND " . $resultcount . " rows";

  echo "<div class='Listview'>";
  echo "<table style='border:solid 1px;'>";
  echo "<tr>";
  foreach($all_columns as $field)
    {
    echo "<th style='border:solid 1px;'><strong>" . $field . "</strong></th>";
    }
  echo "</tr>";

  for ($r=1;$r<=$resultcount;$r++)
    {
    $tmsdata=odbc_fetch_array ($tmsresultset,$r);
    //exit(print_r($tmsdata));
      
      echo "<tr>";
      //print_r($tmsdata);
      foreach($all_columns as $field)
        {  
        if($field=="ThumbBLOB")
          {
          echo "<td  style='border:solid 1px;'><img src='data:image/jpeg;base64," . base64_encode($tmsdata[$field]) . "'/>" . strlen($tmsdata[$field]) . "</td>";
          }
        else
          {
          echo "<td  style='border:solid 1px;'>" . $tmsdata[$field] . "</td>";
          }
        }
      echo "</tr>";
    //echo '<pre>';print_r($tmsdata);echo '</pre>';exit();
    }
  echo "</table>";
  echo "</div>";
  }
  
  